#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2008, Darko Miletic <darko.miletic at gmail.com>'
'''
sciencedaily.com
'''
from calibre.web.feeds.news import BasicNewsRecipe

class ScienceDaily(BasicNewsRecipe):
    title                 = u'ScienceDaily'
    __author__            = u'Darko Miletic'
    description           = u"Breaking science news and articles on global warming, extrasolar planets, stem cells, bird flu, autism, nanotechnology, dinosaurs, evolution -- the latest discoveries in astronomy, anthropology, biology, chemistry, climate &amp; environment, computers, engineering, health &amp; medicine, math, physics, psychology, technology, and more -- from the world's leading universities and research organizations."
    oldest_article        = 7
    language = 'en'

    max_articles_per_feed = 100
    summary_length         = 100
    no_stylesheets        = True
    use_embedded_content  = False

    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                 
    
    cover_url = 'http://www.sciencedaily.com/images/logo.gif'
    
    keep_only_tags = [ 
                        dict(name='h1', attrs={'class':'story'}) 
                       ,dict(name='div', attrs={'id':'story'}) 
                     ]
                     
    remove_tags_after = dict(name='div', attrs={'id':'citationbox'})
    remove_tags = [
                     dict(name='div', attrs={'id':'seealso'})
                    ,dict(name='div', attrs={'id':'citationbox'})
                  ]
    
    feeds       = [(u"Health and Medicine", u'http://www.sciencedaily.com/rss/health_medicine/fitness.xml'),
                        (u"Nutrition", u'http://www.sciencedaily.com/rss/health_medicine/nutrition.xml')
]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		